// Stereo.POV 0.2 demo file.
// 
//  CAMERA TEST
//     by Ichthyostega
//                     
//     (c) Hermann Vosseler 2002
//         This scene may be used or redistributed 
//         for non-commercial purposes, provided
//         this copyright is kept intact.
//
/* ******************************
 * pre declared items
 *     textures and macros
 *   
 *
 */
 
#ifndef (inc_decl) 



#include "metals.inc"     






 // gound texture
//
#declare boden_grund =
texture{
  pigment {
    color red .9 green 0.55 blue 0.23
  }
  finish {       
    ambient 0.4
    diffuse 1
    phong 0.1
    phong_size 1
    specular 0.3
    roughness 1.0
  }
}
                    
#declare boden_strukt=
texture{boden_grund
        pigment{crackle
                colour_map{[.1 colour rgb<.92,.52,.18>]
                           [.4 colour rgb<.9 ,.55,.23>]}
               }
        scale 1/5
       }

#declare boden_nah=
texture {wrinkles
         texture_map{[.40 boden_strukt]
                     [.60 boden_grund]}
         scale 1/500 
        }        

#declare boden_fern =
texture {
  pigment {
    color red .5 green 0.41 blue 0.45
  }
  finish {       
    ambient .4
    diffuse 0.55
  }
}
#declare boden =
texture {spherical
         texture_map{[0.0  boden_fern]
                     [0.83 boden_grund]
                     [0.96 boden_nah]
                    }  
         scale 100
        }             
         


  // -------------------------- 
 //  materials and finishes
//
#declare glanz =
texture {
  pigment {
    color red 1 green 0.9 blue 0.7
  }
  finish {
    diffuse 0.5
    phong 0.5
    phong_size 3
    reflection 0.5
  }
} 
#declare transparent =
texture {
  pigment { color rgbf <0.98, 1.0, 0.99, 0.75>
 }
  finish {
    ambient 0.1
    diffuse 0.1
    reflection .25
    specular 1
    roughness 0.001
  }
}
#declare glas =
interior{
    ior 1.5
}
         
#declare white_paint=
  pigment {
    color red 1 green 1 blue 0.9
  }  
#declare white_grainy=
    pigment {
        granite
        color_map {
            [0.0  rgb <0.9,.55,.23> ]
            [0.03 rgb <0.9,.55,.23> ]
            [0.05 rgb <1,1,0.9>*0.4 ]
            [0.2  rgb <1,1,0.9>*0.4 ]
            [0.25 rgb <1,1,0.9>     ]
            [1.0  rgb <1,1,0.9>     ]
        }
        scale 0.075
    }
         
#declare element_tex_A=
texture {pigment{white_paint}
  normal{bumps 0.3 scale 1/30}
  finish {
    ambient 0.4
    diffuse 0.5 
    brilliance 0.5
    phong 0.2
    phong_size 3
    specular 1.2
    roughness .001
  }
}                     
#declare element_tex_B=
texture{pigment{colour rgbt <0.9,.55,.23,0.95>}
/* ////disabled, because it 
   ////looks too much like marble
  pigment{wrinkles 
          colour_map{[.63 colour rgbf<0,1,0.73,0>]
                     [.631 colour rgbf<0.8,0.82,0.73,0.8>]
                     [.85 colour rgbf<1,1,1,1>]}
         }*/   
  normal{wrinkles 0.5
         scale 1/50 }       
  finish{
    ambient 0.4
    diffuse 0.5 
    brilliance 0.5
    phong 4
    phong_size 130
  }
        scale 1/2 /// or 1/15 ??
       }

#macro element_texturing(pig)
texture{element_tex_A pigment{pig}}
texture{element_tex_B}
texture {pigment{crackle
                 pigment_map{[0    colour rgb <0.9,.55,.23>     ]
                             [0.01 pig                          ]
                             [0.05 pig                          ]
                             [0.14 colour rgbt<0.9,.55,.23,0.9> ]
                             [0.25 colour rgbf<1,1,1,1>         ]}
                 turbulence 0.5
                 octaves 5
                 lambda 4
                 omega 0.8
                 scale 3/5
                }
  finish{
    ambient 0.3
    diffuse 0.6 
    brilliance 0.2
  }
        scale 1/2 /// or 1/15 ??
       }
#end

#declare dull_tex_A =
texture {pigment{colour rgb <0.6,0.45,0.27>}
         finish {ambient 0.4
                 diffuse 0.6 
                 phong 0.7
                 phong_size 3
                 metallic
        }       }
#declare dull_tex_B =
texture {pigment{crackle
                 colour_map{[0    colour rgb 0                  ]
                            [0.02 colour rgb 0                  ]
                            [0.04 colour rgbf<0.53,.19,.09,0.3> ]
                            [0.14 colour rgbf<0.53,.19,.09,0.8> ]
                            [0.25 colour rgbf<1,1,1,1>          ]}
                 turbulence 0.5
                 octaves 4
                 lambda 20
                 omega 0.8
                 scale 1/12           
                }
         finish {ambient 0.2
                 diffuse 0.9 
        }       }           
#declare dull_tex_C =
texture {pigment{bozo
                 colour_map{[0   colour rgbf<0.97,0.6,0.33,0.54>]
                            [0.4 colour rgbf<0.97,0.6,0.33,0.63>]
                            [0.8 colour rgbf<1,1,1,1>           ]
                            [0.8 colour rgbf<1,1,1,1>           ]}
                 turbulence 0.4
                 octaves 4
                 scale 1/2
                }
         normal {dents 0.5 scale 1/12}       
         finish {ambient 0.4
                 diffuse 0.9
                 brilliance 5
                 phong 1
                 phong_size 50
                 metallic
        }       }           
                   
#declare dull_tex =
texture{dull_tex_A}
texture{dull_tex_B}
texture{dull_tex_C}

#macro dull_textured(c)
  texture{dull_tex_A pigment{ colour rgb c}}
  texture{dull_tex_B }
  texture{dull_tex_C}
#end
                   
#declare clock_dial_tex =
texture{ dull_tex_A
  finish {
    brilliance 3
    phong 0.5
    phong_size 100
    reflection <0.02,0.05,0.12>
} }
        
#declare dial_white_col = <0.99,1,0.98>;
#declare dial_black_col = <0.12,0.1,0.02>;

#declare dial_white =
pigment{colour rgb dial_white_col
       }            
       
#declare dial_black =
pigment{colour rgb dial_black_col
       }            

#declare pendulum_tex =
texture{T_Brass_2C
   }

#declare clock_weight_stone=
texture {
    pigment {
        granite
        color_map {
            [0.0 rgb 0.4 ]
            [1.0 rgb 0.7 ]
        }
        scale 0.075
    }
    normal  { granite 0.75 scale 0.075 }
    finish{ambient 0.4
           diffuse 0.8
           brilliance 0.3
          }
}
texture {
    pigment {
        wrinkles
        turbulence 0.3
        scale 0.3
        color_map {
            [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
            [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
        }
    }
    finish{ambient 0.3
           diffuse 0.8
           brilliance 0.6
          }
}


#macro clock_weight_tex(w_diam,i) 
#local offs = div(i,17)*(x+z);
texture{clock_weight_stone
        scale 0.5
        translate -i*w_diam*y + offs}
#end
       
          

#declare T_Wood30x =  //--------based on Dan Farmer's Wood30   (colors reworked)
texture{pigment{     // bottom layer
                 wood
                 colour_map{
                    [ 0.0     rgbft <0.85, 0.675, 0.55,  0.0, 0.0> ]
                    [ 0.1     rgbft <0.85, 0.675, 0.55,  0.0, 0.0> ]
                    [ 0.9     rgbft <0.644, 0.39, 0.276, 0.0, 0.0> ]
                    [ 1.0     rgbft <0.644, 0.39, 0.276, 0.0, 0.0> ]
                 }
                 turbulence 0.04
                 octaves 3
                 ramp_wave
                 scale  <0.05, 0.05, 1.0>
               }  
        finish{ambient 0.3 diffuse 0.4 brilliance 0.5 }      
       }      
texture{pigment{ // semi transparent layer
                 wood
                 colour_map{
                    [ 0.0     rgbf <0.66, 0.384, 0.24, 0.1  > ]
                    [ 0.1     rgbf <0.66, 0.384, 0.24, 0.5  > ]
                    [ 0.1     rgbf <0.66, 0.42,  0.24, 0.65 > ]
                    [ 0.2     rgbf <0.85, 0.675, 0.55, 0.975> ]
                    [ 0.3     rgbf <0.63, 0.36,  0.27, 1.0  > ]
                    [ 0.4     rgbf <0.63, 0.36,  0.27, 0.5  > ]
                    [ 0.9     rgbf <0.85, 0.675, 0.55, 0.975> ]
                    [ 1.0     rgbf <0.63, 0.393, 0.27, 1.0  > ]
                 }
                 turbulence 0.1
                 octaves 5
                 lambda 3.25
                 ramp_wave
                 scale  <0.15, 0.5, 1.0>
                 rotate    <5.0, 10.0, 5.0>
                 translate -2.0 * x
               }  
        finish{ambient 0.3 diffuse 0.6}      
       } 
texture{pigment{ // dust layer
                bozo
                colour_map{
                   [0.0   rgbf<0.97,0.6, 0.33,0.72>]
                   [0.4   rgbf<0.97,0.6, 0.33,0.72>]
                   [0.6   rgbf<0.9 ,0.55,0.23,0.9 >]
                   [1.0   rgbf<0.9 ,0.55,0.23,0.9 >]
                }
                scale <3,0.3,1>
                turbulence 0.3
               }  
        finish{ambient 0.2 diffuse 0.9}      
       }


#declare panel_seq = 0;       

  // cutting out slices of this for the panels
 //
#macro panel_texture(loc,diam,thick)

   #local offs = vlength(loc)/diam;
   #declare panel_seq = panel_seq+1;
   #local ser = div(panel_seq,(1+div(offs,30)));
   

        texture{ T_Wood30x 
                 scale 0.14
                 rotate 5*x
          rotate -ser*y*30 
          translate ser*diam*z + offs*thick*y      
        }
#end 

   //
  //______________________          
 // Chain generating macro 
//
#declare chain_tex = 
texture{T_Brass_2C
        finish{diffuse 0.3}}


#macro chain(len)
    // from origin 
   //  in y-direction to given length
  //
  #local linkLen = 0.1;
  #local linkDiam = 0.04;
  #local linkThick = .2;  // % of diameter
  
  #local r = linkThick*linkDiam;
  #local R = (linkDiam-2*r)/2;

  #if (3*r > R)
    #local r =  linkDiam/2/4;    
    #local R = (linkDiam-2*r)/2;
  #end
  #local link_inc = linkLen-4*r;
  #if (link_inc <= 0)
    #local linkLen = 1.1*linkDiam;
    #local link_inc = linkLen-4*r;
  #end                   
  
   // adjust, so it creates desired length
  #local link_cnt = div(len+4*r, link_inc);
  #local linkLen = linkLen + (len+4*r - link_cnt*link_inc)/link_cnt;

  #local rR=r+R;
  #local sL=(linkLen-2*rR)/2;
  
  #declare Half_Torus = difference{ torus{R,r sturm  rotate x*-90 }
                                    box { <-rR, -rR, -r>, <rR, 0, r> }
                                  }
  
  #declare Chain_Segment = cylinder { <0, sL, 0>, <0, -sL, 0>, r  }

  #declare Link = union {
    object { Half_Torus    translate  y*sL }
    object { Half_Torus    translate  y*sL rotate x*180 }
    object { Chain_Segment translate  x*R  }
    object { Chain_Segment translate -x*R  }
  } 
     // Note: Centered at origin.
    //  The chain will go half the length of a link
   //   beyond the desired Start/End points. 
  //   
 // now let'S do it! 
 #local i=0;         
    
 
union{  
 #while (i<=link_cnt)
       object{Link rotate i*90*y 
                   translate i*link_inc*y
                   texture { chain_tex translate i*linkLen*x}}      
        #local i=i+1;
 #end
     }
#end




#declare inc_decl = true;
      // done including
#end // general definitions
